<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");
require ("./loginverify.php");
require ("./functions.php");

/*
 * Find out what the user is trying to update.
 * If nothing was passed to the URL, produce an error
 * because this page is not meant to be accessed directly.
 */
if (isset($_GET['update']) && !empty($_GET['update'])) {
	$update = $_GET['update'];
} else {
	$start_time = micro_time(0);
	bodyHeader('error', $version_num);
	bodyNavigation('error'); ?>
		<h1>Error!</h1>
		<p>No update action has been specified. What are you trying to update?</p>
		</div>
	<?php bodyFooter('error', $start_time); exit();
}


/*
 * Optimize the ad_check logs table to purge all the old and unneccessary data.
 * It will delete anything older than the clickmaxtime variable.
 */
$backlog_timeframe = $timestamp - $clickmaxtime;
mysql_query("DELETE FROM " . $db_table_prefix . "adcheck_logs WHERE timestamp < '$backlog_timeframe'");
mysql_query("OPTIMIZE TABLE " . $db_table_prefix . "adcheck_logs");


/*
 * If the user is trying to update the index stats,
 * perform this code to do that.
 */
if ($update == 'index') {

	/*
	 * Go through each of the date ranges and count the
	 * number of clicks that exist for each of them.
	 */
	// For today:
		$today_timestamp = mktime(0, 0, 0, date('n', $timestamp), date('d', $timestamp), date('Y', $timestamp));
		// All clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$click_count_today = $row['COUNT(id)'];
		// Unique clicks:
		$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$unique_visitors_click_today = $row['COUNT(DISTINCT visitor_ip)'];
		// Ad clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_as' AND timestamp >= '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$ad_clicks_today = $row['COUNT(id)'];
		// Link clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_0ads_al%' AND timestamp >= '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$link_clicks_today = $row['COUNT(id)'];

	// For yesterday:
		$yesterday_timestamp = mktime(0, 0, 0, date('n', $timestamp), date('d', $timestamp) - 1, date('Y', $timestamp));
		// All clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$yesterday_timestamp' AND timestamp < $today_timestamp");
			$row = mysql_fetch_array($result);
			$click_count_yesterday = $row['COUNT(id)'];
		// Unique clicks:
		$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$yesterday_timestamp' AND timestamp < $today_timestamp");
			$row = mysql_fetch_array($result);
			$unique_visitors_click_yesterday = $row['COUNT(DISTINCT visitor_ip)'];
		// Ad clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_as' AND timestamp >= '$yesterday_timestamp' AND timestamp < '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$ad_clicks_yest = $row['COUNT(id)'];
		// Link clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_0ads_al%' AND timestamp >= '$yesterday_timestamp' AND timestamp < '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$link_clicks_yest = $row['COUNT(id)'];

	// For this week:
		$weekago_timestamp = mktime(0, 0, 0, date('n', $timestamp), date('d', $timestamp) - 7, date('Y', $timestamp));
		// All clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$weekago_timestamp'");
			$row = mysql_fetch_array($result);
			$click_count_week = $row['COUNT(id)'];
		// Unique clicks:
		$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$weekago_timestamp'");
			$row = mysql_fetch_array($result);
			$unique_visitors_click_week = $row['COUNT(DISTINCT visitor_ip)'];
		// Ad clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_as' AND timestamp >= '$weekago_timestamp'");
			$row = mysql_fetch_array($result);
			$ad_clicks_week = $row['COUNT(id)'];
		// Link clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_0ads_al%' AND timestamp >= '$weekago_timestamp'");
			$row = mysql_fetch_array($result);
			$link_clicks_week = $row['COUNT(id)'];
	
	// Overall
		// All clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles");
			$row = mysql_fetch_array($result);
			$click_count_overall = $row['COUNT(id)'];
		// Unique clicks:
		$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "logfiles");
			$row = mysql_fetch_array($result);
			$unique_visitors_click = $row['COUNT(DISTINCT visitor_ip)'];
		// Ad clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_as'");
			$row = mysql_fetch_array($result);
			$ad_clicks_overall = $row['COUNT(id)'];
		// Link clicks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE format LIKE '%_0ads_al%'");
			$row = mysql_fetch_array($result);
			$link_clicks_overall = $row['COUNT(id)'];

	/*
	 * Finally, update the QuickStats table with all those values.
	 */
	$sql = "
			UPDATE " . $db_table_prefix . "quickstats
				SET `last_update_time` = " . $timestamp . ",
					`index.today.total` = " . $click_count_today . ",
					`index.today.unique` = " . $unique_visitors_click_today . ",
					`index.today.ads` = " . $ad_clicks_today . ",
					`index.today.links` = " . $link_clicks_today . ",
					`index.yesterday.total` = " . $click_count_yesterday . ",
					`index.yesterday.unique` = " . $unique_visitors_click_yesterday . ",
					`index.yesterday.ads` = " . $ad_clicks_yest . ",
					`index.yesterday.links` = " . $link_clicks_yest . ",
					`index.week.total` = " . $click_count_week . ",
					`index.week.unique` = " . $unique_visitors_click_week . ",
					`index.week.ads` = " . $ad_clicks_week . ",
					`index.week.links` = " . $link_clicks_week . ",
					`index.overall.total` = " . $click_count_overall . ",
					`index.overall.unique` = " . $unique_visitors_click . ",
					`index.overall.ads` = " . $ad_clicks_overall . ",
					`index.overall.links` = " . $link_clicks_overall . "
				WHERE `id` = '1'
			";
	$result = mysql_query($sql);

/*
 * If the person is trying to update the blocked stats,
 * perform this code.
 */
} elseif ($update == 'blocks') {
	/*
	 * First, delete any blocked entries that are older than one week.
	 */
	$backlog_timeframe = $timestamp - 7*24*60*60;
	mysql_query("DELETE FROM " . $db_table_prefix . "blocklogs WHERE timestamp < '$backlog_timeframe'");
	mysql_query("OPTIMIZE TABLE " . $db_table_prefix . "blocklogs");

	/*
	 * Go through each of the date ranges and count the
	 * number of blocks that exist for each of them.
	 */
	// For today:
		$today_timestamp = mktime(0, 0, 0, date('n', $timestamp), date('d', $timestamp), date('Y', $timestamp));
		// All blocks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "blocklogs WHERE timestamp >= '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$block_count_today = $row['COUNT(id)'];
		// Unique blocks:
		$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "blocklogs WHERE timestamp >= '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$block_visitors_today = $row['COUNT(DISTINCT visitor_ip)'];
	
	// For yesterday:
		$yesterday_timestamp = mktime(0, 0, 0, date('n', $timestamp), date('d', $timestamp) - 1, date('Y', $timestamp));
		// All blocks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "blocklogs WHERE timestamp >= '$yesterday_timestamp' AND timestamp < '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$block_count_yesterday = $row['COUNT(id)'];
		// Unique blocks:
		$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "blocklogs WHERE timestamp >= '$yesterday_timestamp' AND timestamp < '$today_timestamp'");
			$row = mysql_fetch_array($result);
			$block_visitors_yesterday = $row['COUNT(DISTINCT visitor_ip)'];
	
	// For this week:
		$weekago_timestamp = mktime(0, 0, 0, date('n', $timestamp), date('d', $timestamp) - 7, date('Y', $timestamp));
		// All blocks:
		$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "blocklogs WHERE timestamp >= '$weekago_timestamp'");
			$row = mysql_fetch_array($result);
			$block_count_week = $row['COUNT(id)'];
		// Unique blocks:
		$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "blocklogs WHERE timestamp >= '$weekago_timestamp'");
			$row = mysql_fetch_array($result);
			$block_visitors_week = $row['COUNT(DISTINCT visitor_ip)'];

	/*
	 * Finally, update the QuickStats table with all those values.
	 */
	$sql = "
			UPDATE " . $db_table_prefix . "quickstats
				SET `last_update_time` = " . $timestamp . ",
					`block.today.total` = " . $block_count_today . ",
					`block.today.unique` = " . $block_visitors_today . ",
					`block.yesterday.total` = " . $block_count_yesterday . ",
					`block.yesterday.unique` = " . $block_visitors_yesterday . ",
					`block.week.total` = " . $block_count_week . ",
					`block.week.unique` = " . $block_visitors_week . "
				WHERE `id` = 2
			";
	$result = mysql_query($sql);

/*
 * If the person is trying to update the database size variable,
 * perform this code.
 */
} elseif ($update == 'db_size') {

	/*
	 * Declare an array that will query each table to find out the size of each.
	 */
	$sql[0] = "SHOW TABLE STATUS LIKE \"" . $db_table_prefix . "adcheck_logs\"";
	$sql[1] = "SHOW TABLE STATUS LIKE \"" . $db_table_prefix . "blocklogs\"";
	$sql[2] = "SHOW TABLE STATUS LIKE \"" . $db_table_prefix . "channels\"";
	$sql[3] = "SHOW TABLE STATUS LIKE \"" . $db_table_prefix . "logfiles\"";
	$sql[4] = "SHOW TABLE STATUS LIKE \"" . $db_table_prefix . "quickstats\"";
	$sql[5] = "SHOW TABLE STATUS LIKE \"" . $db_table_prefix . "users\"";

	$db_size = 0;

	// Go through and perform each of those queries
	foreach($sql as $query) {
		$result = mysql_query($query);
			$row = mysql_fetch_array($result);
				// Calculate the size of that table based on the data and index length.
				$db_size += $row['Data_length'] + $row['Index_length'];
	}

	// Finally, update the quickstats table with those values.
	$sql = "UPDATE " . $db_table_prefix . "quickstats
				SET `last_update_time` = " . $timestamp . ",
					`db_size` = " . $db_size . "
				WHERE `id` = 3
			";
	$result = mysql_query($sql);

	$_SESSION['changesuccess'] = "The database size has been successfully updated.";

} else {
	/*
	 * If a differrent, invalid, update action was specified,
	 * produce an error.
	 */
	$start_time = micro_time(0);
	bodyHeader('error', $version_num);
	bodyNavigation('error'); ?>
		<h1>Error!</h1>
		<p>An invalid update action has been specified.</p>
		</div>
	<?php bodyFooter('error', $start_time); exit();
}

/*
 * If the referrer was passed via the URL, send the person
 * back to where they came from.  Else just send them back
 * to the index page.
 */
if (isset($_GET['ref']) && !empty($_GET['ref'])) {
	$ref = $_GET['ref'];
} else {
	$ref = './';
}
header("Location: " . $ref);
exit();
?>